using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using UnityEngine;
using UnityEngine.UI;
using Newtonsoft.Json;
using System.IO;


public class SpeedrunTimer : MonoBehaviour
{
    
    TimeSpan timePlaying;
    float elapsedTime;
    bool isActive = false;
    public bool isRunning = false;
    public Text timer;
    public Toggle timerToggle;
    // Start is called before the first frame update
    void Start()
    {
        string contents = File.ReadAllText(@"C:\ProgramData\YouAreWhatYouEat\Settings.json");
        SettingsClass temp = JsonConvert.DeserializeObject<SettingsClass>(contents);
        bool activated = temp.ESTL;
        timerToggle.isOn = activated;
        if(activated)
        {
            UnityEngine.Debug.Log("Activated speedrun timer automatically");
        }
        else
        {
            gameObject.transform.localScale = new Vector3(0, 0, 0);
        }
        
        UnityEngine.Debug.Log("works");
        isRunning = true;
        
        
    }
    
    // Update is called once per frame
    void Update()
    {
        if (isRunning)
        {
            elapsedTime += Time.deltaTime;
            timePlaying = TimeSpan.FromSeconds(elapsedTime);
            timer.text = timePlaying.ToString("hh':'mm':'ss'.'ff");
        }
    }
    public void valueChange()
    {
        isActive = !isActive;
        string contents = File.ReadAllText(@"C:\ProgramData\YouAreWhatYouEat\Settings.json");
        SettingsClass tempRead = JsonConvert.DeserializeObject<SettingsClass>(contents);
        SettingsClass tempWrite = new SettingsClass(isActive, tempRead.volumeL,tempRead.AV);
        string serialized = JsonConvert.SerializeObject(tempWrite);
        File.WriteAllText(@"C:\ProgramData\YouAreWhatYouEat\Settings.json", serialized);
        if (isActive)
        {
            gameObject.transform.localScale = new Vector3(1, 1, 1);
        }
        else
        {
            gameObject.transform.localScale = new Vector3(0,0,0);
        }
    }
}